import { View, Text, TouchableOpacity } from "react-native";
import React from "react";
import DownIcon from "../../../assets/svgs/dropdown/down.svg";
import UpIcon from "../../../assets/svgs/dropdown/up.svg";
import { filtersStyles } from "./filtersStyle";
import dpr from "../../Utilities/CustomStyleAttribute/dpr";
import useLangTranslation from "../../../hooks/useLangTranslation";
import CustomSVG from "../../../src/components/CustomSVG/CustomSVG";

const iconHeight = dpr(8);
const iconWidth = dpr(16);

const FilterSelect = ({ item, handleUpDownIcon, show }) => {
    const {trans} = useLangTranslation();
    return (
        <View style={filtersStyles.selectCont}>
            <TouchableOpacity
                style={filtersStyles.subSelectCont}
                onPress={() => handleUpDownIcon(item)}
            >
                <Text style={filtersStyles.selectText}>{trans("Select {{x}}", {x: item})}</Text>
                {show ? (
                    <CustomSVG svgIcon={UpIcon} height={iconHeight} width={iconWidth} />
                ) : (
                    <CustomSVG svgIcon={DownIcon}
                        height={iconHeight}
                        width={iconWidth}
                        fill={"#2C2C2C"}
                    />
                )}
            </TouchableOpacity>
        </View>
    );
};

export default FilterSelect;
